﻿<%@ Control Language="C#" AutoEventWireup="true" CodeFile="ucNoteSelection.ascx.cs" Inherits="ucNoteSelection" %>
<script type="text/javascript">
    function fnUCNoteSelUpdate() {
        Ext.getCmp('tfEventNoteTitle').setValue(Ext.getCmp('tfNoteTitle').getValue());
        Ext.getCmp('tfEventNoteLocation').setValue(Ext.getCmp('tfEncounterlocation').getValue());
        Ext.getCmp('tfEvtNoteConsult').setValue(Ext.getCmp('tfEncConsult').getValue());
        Ext.getCmp('tfEvtNoteCosigner').setValue(Ext.getCmp('tfCoSigner').getValue());
    }

    function fnNoteTitleValSearch() {
        if (App.tfNoteTitleSearch.isValid()) {
            App.btnSearchNoteTitle.setDisabled(false);
        } else {
            App.btnSearchNoteTitle.setDisabled(true);
        }
        //fnNoteSelectValForm();
    }

    function fnNewVisitValSearch() {
        if (App.tfClinicSearch.isValid()) {
            App.btnSearchClinic.setDisabled(false);
        } else {
            App.btnSearchClinic.setDisabled(true);
        }
        //fnNoteSelectValForm();
    }

    function fnNoteConsultValForm() {
        if (App.dfConsultFromDate.isValid() && App.dfConsultToDate.isValid()) {
            App.btnSearchConsults.setDisabled(false);
        } else {
            App.btnSearchConsults.setDisabled(true);
        }
        //fnNoteSelectValForm();
    }

    function fnNoteCApptValForm() {
        if (App.dfApptFromDate.isValid() && App.dfApptToDate.isValid()) {
            App.btnSearchAppointments.setDisabled(false);
        } else {
            App.btnSearchAppointments.setDisabled(true);
        }
        //fnNoteSelectValForm();
    }

    function fnNoteVisitValForm() {
        if (App.dfVisitFromDate.isValid() && App.dfVisitToDate.isValid()) {
            App.btnSearchVisits.setDisabled(false);
        } else {
            App.btnSearchVisits.setDisabled(true);
        }
        //fnNoteSelectValForm();
    }

    function fnNoteAdminValForm() {
        if (App.dfAdmitFromDate.isValid() && App.dfAdmitToDate.isValid()) {
            App.btnSearchAdmissions.setDisabled(false);
        } else {
            App.btnSearchAdmissions.setDisabled(true);
        }
        //fnNoteSelectValForm();
    }

    //function fnNoteSelectValForm() {
    //    if (App.tfNoteTitleSearch.isValid() && App.tfClinicSearch.isValid() &&
    //        App.dfVisitFromDate.isValid() && App.dfVisitToDate.isValid() &&
    //        App.dfAdmitFromDate.isValid() && App.dfAdmitToDate.isValid() &&
    //        App.dfConsultFromDate.isValid() && App.dfConsultToDate.isValid() &&
    //        App.dfNewVisitDate.isValid() && App.tfNewVisitTime.isValid()) {
    //        App.btnEventNoteOK.setDisabled(false);
    //    }
    //    else {
    //        App.btnEventNoteOK.setDisabled(true);
    //    }
    //}

    function fnHideNoteSelection() {
        App.tfNoteTitleSearch.clear();
        App.tfClinicSearch.clear();
        App.tfCosignerSearch.clear();

        App.dfNewVisitDate.clear();
        App.tfNewVisitTime.clear();

        App.dfNewVisitDate.clearInvalid();
        App.tfNewVisitTime.clearInvalid();
    }

</script>
<ext:Window ID="wndSelectNote" Title="Select the note title and visit for the TIU note." Hidden="true"
    Layout="AnchorLayout" Height="515" Width="855" 
    IDMode="Static" runat="server" Constrain="true"
    
    Modal="true"
    Collapsible="false"
    Resizable="false"
    Maximizable="false"
    Draggable="false" 
    XOnEsc="Ext.emptyFn">
<Listeners>
    <BeforeShow Handler="App.pnlMMenu.mask();App.vpMasterViewport.mask();"></BeforeShow>
    <Hide Handler="App.pnlMMenu.unmask();App.vpMasterViewport.unmask();" />
    <Close Handler="App.pnlMMenu.unmask();App.vpMasterViewport.unmask();" ></Close>
</Listeners>
<Items>
   
    <ext:Panel Border="false" Layout="ColumnLayout" runat="server" Padding="3" Width="850">
        <Items>
            <ext:Label Width="145" Padding="5" Text="Note Title" runat="server"></ext:Label>

            <ext:TextField AutoDataBind="true"
                Padding="3" ID="tfNoteTitle" ReadOnly="true" Width="680" runat="server">
            </ext:TextField>
        </Items>
    </ext:Panel>

    <ext:Panel Border="false" Layout="ColumnLayout" runat="server" Padding="3" Width="850">
        <Items>
            <ext:Label Width="145" Padding="5" Text="Encounter Location" runat="server"></ext:Label>
            <ext:TextField AutoDataBind="true"
                Padding="3" ID="tfEncounterlocation" ReadOnly="true" Width="680" runat="server">
            </ext:TextField>
        </Items>
    </ext:Panel>

    <ext:Panel  Border="false" Layout="ColumnLayout" runat="server" Padding="3" Width="850">
        <Items>
            <ext:Label  Width="145" Padding="5" Text="Consult" runat="server"></ext:Label>
            <ext:TextField AutoDataBind="true"
                Padding="3" ID="tfEncConsult" ReadOnly="true" Width="680" runat="server">
            </ext:TextField>
        </Items>
    </ext:Panel>

    <ext:Panel Border="false" Layout="ColumnLayout" runat="server" Padding="3" Width="850">
        <Items>

            <ext:Label Width="145" Padding="5" Text="Cosigner" runat="server"></ext:Label>

            <ext:TextField AutoDataBind="true"
                Padding="3" ID="tfCoSigner" ReadOnly="true" Width="680" runat="server">
            </ext:TextField>

        </Items>
    </ext:Panel>

    <ext:TabPanel Border="false" Layout="AnchorLayout" 
        ID="TabPanelNote" Height="250" Width="850" Margins="0 0 0 0" 
        runat="server">
        <Defaults>
            <ext:Parameter Name="bodyPadding" Value="10" Mode="Raw" />
            <ext:Parameter Name="autoScroll" Value="false" Mode="Raw" />
        </Defaults>
        <Items>

            <ext:Panel Border="false" ID="tpNoteTitles" Title="Note Title" runat="server" AutoDataBind="true">
                <Items>

                    <ext:Panel Layout="ColumnLayout" runat="server" Border="false">
                        <Items>
                            <ext:Label Padding="5" Text="Search" runat="server"></ext:Label>

                            <ext:TextField MinLength="3" MaxLength="50" Padding="3" ID="tfNoteTitleSearch" ReadOnly="false"
                                Width="300" runat="server" Vtype="alphanumXSS">
                                <Listeners>
                                    <Change Fn="fnNoteTitleValSearch" />
                                </Listeners>
                            </ext:TextField>

                            <ext:Button Text="Search Note Titles" Handler="App.direct.UCNOTESEL.SearchNoteTitles();" Padding="5"
                                Icon="Magnifier" ID="btnSearchNoteTitle" runat="server">
                                <Listeners>

                                </Listeners>
                            </ext:Button>
                        </Items>
                    </ext:Panel>

                    <ext:GridPanel
                        ID="gpNoteTitle"
                        runat="server"
                        AnchorHorizontal="98%"
                        Height="190"
                        Padding="1" Border="false">
                        <Listeners>
                            <CellClick Handler="App.direct.UCNOTESEL.OnNoteTitleSelect( Ext.encode(this.store.getAt(rowIndex).data) );" />
                        </Listeners>
                        <SelectionModel>
                            <ext:RowSelectionModel ID="smNoteTitle" runat="server" />
                        </SelectionModel>
                        <ColumnModel ID="cmdlTitle" runat="server">
                            <Columns>

                                <ext:Column runat="server"
                                    DataIndex="NOTE_TITLE_TAG" Text="IEN"
                                    Flex="13" />

                                <ext:Column runat="server"
                                    DataIndex="NOTE_TITLE_LABEL" Text="Note Title"
                                    Flex="71">
                                    <Renderer Handler="return Ext.util.Format.htmlDecode(value);" />
                                </ext:Column>

                                <ext:Column runat="server"
                                    DataIndex="CONSULT_YN" Text="Consult"
                                    Flex="9" />

                            </Columns>
                        </ColumnModel>
                        <Store>
                            <ext:Store
                                ID="storNoteTitle"
                                AutoLoad="true"
                                runat="server">
                                <Model>
                                    <ext:Model ID="mdlNoteTitle" runat="Server" IDProperty="NOTE_TITLE_TAG,NOTE_TITLE_LABEL">
                                        <Fields>
                                            <ext:ModelField Name="NOTE_TITLE_TAG" />
                                            <ext:ModelField Name="NOTE_TITLE_LABEL" />
                                            <ext:ModelField Name="IS_CONSULT" />
                                            <ext:ModelField Name="CONSULT_YN" />
                                        </Fields>
                                    </ext:Model>
                                </Model>
                                <Reader>
                                    <ext:JsonReader RootProperty="Tables[0].Rows">
                                    </ext:JsonReader>
                                </Reader>
                            </ext:Store>
                        </Store>
                    </ext:GridPanel>

                </Items>
            </ext:Panel>

            <ext:Panel ID="tpConsults"
                runat="server"
                Title="Consult"
                AutoDataBind="true" Border="false" >
                <Items>

                    <ext:Panel Border="false"  ID="pnlConsultDateRange" Layout="ColumnLayout" runat="server">
                        <Items>
                            <ext:Label Text="From" runat="server" Padding="3"></ext:Label>
                            <ext:DateField ID="dfConsultFromDate"
                                runat="server"
                                AllowBlank="false"
                                AutoDataBind="true"
                                Width="100"
                                Padding="5"
                                Format="MM/dd/yyyy"
                                Vtype="date"
                                InvalidText="{0} is not a valid date - it must be in the format MM/DD/YYYY">
                                <Listeners>
                                    <Change Fn="fnNoteConsultValForm" />
                                </Listeners>
                            </ext:DateField>

                            <ext:Label Text="Through" runat="server" Padding="3"></ext:Label>
                            <ext:DateField ID="dfConsultToDate"
                                runat="server"
                                AllowBlank="false"
                                AutoDataBind="true"
                                Width="100"
                                Padding="5"
                                Format="MM/dd/yyyy"
                                Vtype="date"
                                InvalidText="{0} is not a valid date - it must be in the format MM/DD/YYYY">
                                <Listeners>
                                    <Change Fn="fnNoteConsultValForm" />
                                </Listeners>
                            </ext:DateField>

                            <ext:Button Text="Search Consults" Handler="App.direct.UCNOTESEL.SearchConsults();"
                                Padding="5" Icon="Magnifier" ID="btnSearchConsults" runat="server">
                            <Listeners>

                            </Listeners>
                            </ext:Button>

                        </Items>
                    </ext:Panel>

                    <ext:GridPanel
                        ID="gpNoteConsult"
                        runat="server"
                        AnchorHorizontal="98%"
                        Height="190"
                        Padding="1" Border="false" >
                        <Listeners>
                            <CellClick Handler="App.direct.UCNOTESEL.OnConsultSelect( Ext.encode(this.store.getAt(rowIndex).data) );" />
                        </Listeners>
                        <SelectionModel>
                            <ext:RowSelectionModel ID="smNoteConsult" runat="server" />
                        </SelectionModel>
                        <ColumnModel ID="cmNoteConsult" runat="server">
                            <Columns>

                                <ext:DateColumn runat="server"
                                    DataIndex="CONSULT_DATETIME" Text="Date/Time"
                                    Flex="23"  Format="Y-m-dd HH:i:s" />

                                <ext:Column runat="server"
                                    DataIndex="CONSULT_TITLE" Text="Title"
                                    Flex="48">
                                <Renderer Handler="return Ext.util.Format.htmlDecode(value);" />
                                </ext:Column>

                                <ext:Column runat="server"
                                    DataIndex="CONSULT_STATUS" Text="Status"
                                    Flex="15">
                                <Renderer Handler="return Ext.util.Format.htmlDecode(value);" />
                                </ext:Column>

                            </Columns>
                        </ColumnModel>
                        <Store>
                            <ext:Store
                                ID="storNoteConsult"
                                AutoLoad="true"
                                runat="server">
                                <Model>
                                    <ext:Model ID="mdlNoteConsult" runat="Server" IDProperty="CONSULT_ID">
                                        <Fields>
                                            <ext:ModelField Name="CONSULT_ID" />
                                            <ext:ModelField Name="CONSULT_DATETIME" Type="Date" />
                                            <ext:ModelField Name="CONSULT_STATUS" />
                                            <ext:ModelField Name="CONSULT_TITLE" />
                                        </Fields>
                                    </ext:Model>
                                </Model>
                                <Reader>
                                    <ext:JsonReader RootProperty="Tables[0].Rows">
                                    </ext:JsonReader>
                                </Reader>
                            </ext:Store>
                        </Store>
                    </ext:GridPanel>

                </Items>
            </ext:Panel>

            <ext:Panel ID="tpClinicAppointments"
                runat="server"
                Title="Clinic Appointments" Visible="false"
                AutoDataBind="true" Border="false" >
                <Items>

                    <ext:Panel ID="pnlApptDateRange" Layout="ColumnLayout" runat="server" Border="false" >
                        <Items>
                            <ext:Label Text="From" runat="server" Padding="3"></ext:Label>
                            <ext:DateField ID="dfApptFromDate"
                                runat="server"
                                AllowBlank="false"
                                AutoDataBind="true"
                                Width="100"
                                Padding="5"
                                Format="MM/dd/yyyy"
                                Vtype="date"
                                InvalidText="{0} is not a valid date - it must be in the format MM/DD/YYYY">
                                <Listeners>
                                    <Change Fn="fnNoteCApptValForm" />
                                </Listeners>
                            </ext:DateField>

                            <ext:Label Text="Through" runat="server" Padding="3"></ext:Label>
                            <ext:DateField ID="dfApptToDate"
                                runat="server"
                                AllowBlank="false"
                                AutoDataBind="true"
                                Width="100"
                                Padding="5"
                                Format="MM/dd/yyyy"
                                Vtype="date"
                                InvalidText="{0} is not a valid date - it must be in the format MM/DD/YYYY">
                                <Listeners>
                                    <Change Fn="fnNoteCApptValForm" />
                                </Listeners>
                            </ext:DateField>

                            <ext:Button Text="Search Appointments" Handler="App.direct.UCNOTESEL.SearchAppointments();"
                                Padding="5" Icon="Magnifier" ID="btnSearchAppointments" runat="server">
                            <Listeners>

                            </Listeners>
                            </ext:Button>

                        </Items>
                    </ext:Panel>

                    <ext:GridPanel
                        ID="gpNoteAppt"
                        runat="server"
                        AnchorHorizontal="98%"
                        Height="222" 
                        Padding="1" Border="false" 
                        >
                        <Listeners>
                            <CellClick Handler="App.direct.UCNOTESEL.OnAppointmentSelect(  Ext.encode(this.store.getAt(rowIndex).data) );" />
                        </Listeners>
                        <SelectionModel>
                            <ext:RowSelectionModel ID="smNoteAppt" runat="server" />
                        </SelectionModel>
                        <ColumnModel ID="cmdlAppt" runat="server">
                            <Columns>

                                <ext:DateColumn runat="server"
                                    DataIndex="APPT_DATETIME" Text="Date/Time"
                                    Flex="23" Format="Y-m-dd HH:i:s" />

                                <ext:Column ID="colApptClinicLabel" runat="server"
                                    DataIndex="CLINIC_LABEL" Text="Clinic" 
                                    Flex="51">
                                <Renderer Handler="return Ext.util.Format.htmlDecode(value);" />
                                </ext:Column>
                                
                                <ext:Column ID="colApptCurrentStatus" runat="server"
                                    DataIndex="APPT_CURRENT_STATUS" Text="Current Status"
                                    Flex="25">
                                <Renderer Handler="return Ext.util.Format.htmlDecode(value);" />
                                </ext:Column>

                            </Columns>
                        </ColumnModel>
                        <Store>
                            <ext:Store
                                ID="storNoteAppt"
                                AutoLoad="true"
                                runat="server">
                                <Model>
                                    <ext:Model ID="mdlNoteAppt" runat="Server" IDProperty="APPT_ID">
                                        <Fields>
                                            <ext:ModelField Name="APPT_ID" />
                                            <ext:ModelField Name="REGION_ID" />
                                            <ext:ModelField Name="SITE_ID" />
                                            <ext:ModelField Name="DFN" />
                                            <ext:ModelField Name="APPT_DATETIME" Type="Date"  />
                                            <ext:ModelField Name="CLINIC_LABEL" />
                                            <ext:ModelField Name="APPT_CLINIC_ID" />
                                            <ext:ModelField Name="APPT_CURRENT_STATUS" />
                                            <ext:ModelField Name="APPT_PURPOSE" />
                                            <ext:ModelField Name="APPT_TIMESTAMP" />
                                            <ext:ModelField Name="APPT_VISIT_ID" />
                                            <ext:ModelField Name="APPT_TYPE" />
                                        </Fields>
                                    </ext:Model>
                                </Model>
                                <Reader>
                                    <ext:JsonReader RootProperty="Tables[0].Rows">
                                    </ext:JsonReader>
                                </Reader>
                            </ext:Store>
                        </Store>
                    </ext:GridPanel>

                </Items>
            </ext:Panel>

            <ext:Panel ID="tpVisits"
                runat="server"
                Title="Visits"
                AutoDataBind="true"  Border="false" >
                <Items>

                    <ext:Panel ID="pnlVisitDateRange" Layout="ColumnLayout" runat="server" Border="false">
                        <Items>
                            <ext:Label ID="Label1ucnotesel"  Text="From" runat="server" Padding="3"></ext:Label>
                            <ext:DateField ID="dfVisitFromDate"
                                runat="server"
                                AllowBlank="false"
                                MaxDate="<%# DateTime.Today %>"
                                AutoDataBind="true"
                                Width="100"
                                Padding="5"
                                Format="MM/dd/yyyy"
                                Vtype="date"
                                InvalidText="{0} is not a valid date - it must be in the format MM/DD/YYYY">
                                <Listeners>
                                    <Change Fn="fnNoteVisitValForm" />
                                </Listeners>
                            </ext:DateField>

                            <ext:Label ID="Label2ucnotesel" Text="Through" runat="server" Padding="3"></ext:Label>
                            <ext:DateField ID="dfVisitToDate"
                                runat="server"
                                AllowBlank="false"
                                MaxDate="<%# DateTime.Today %>"
                                AutoDataBind="true"
                                Width="100"
                                Padding="5"
                                Format="MM/dd/yyyy"
                                Vtype="date"
                                InvalidText="{0} is not a valid date - it must be in the format MM/DD/YYYY">
                                <Listeners>
                                    <Change Fn="fnNoteVisitValForm" />
                                </Listeners>
                            </ext:DateField>

                            <ext:Button Text="Search Visits" Handler="App.direct.UCNOTESEL.SearchVisits();"
                                Padding="5" Icon="Magnifier" ID="btnSearchVisits" runat="server">
                            <Listeners>

                            </Listeners>
                            </ext:Button>

                        </Items>
                    </ext:Panel>

                    <ext:GridPanel
                        ID="gpNoteVisit"
                        runat="server"
                        AnchorHorizontal="98%"
                        Height="190"
                        Padding="1" Border="false" >
                        <Listeners>
                            <CellClick Handler="App.direct.UCNOTESEL.OnNoteVisitSelect( Ext.encode(this.store.getAt(rowIndex).data) );" />
                        </Listeners>
                        <SelectionModel>
                            <ext:RowSelectionModel ID="smNoteVisit" runat="server" />
                        </SelectionModel>
                        <ColumnModel ID="cmNoteVisit" runat="server">
                            <Columns>

                                <ext:DateColumn   runat="server"
                                    DataIndex="VISIT_DATETIME" Text="Date/Time"
                                    Flex="23" Format="Y-m-dd HH:i:s" />

                                <ext:Column   runat="server"
                                    DataIndex="VISIT_LOCATION_NAME" Text="Title"
                                    Flex="38" />

                                <ext:Column   runat="server"
                                    DataIndex="VISIT_STATUS" Text="Status"
                                    Flex="18" />

                                <ext:Column  runat="server"
                                    DataIndex="VISIT_TYPE" Text="Type"
                                    Flex="15" />

                            </Columns>
                        </ColumnModel>
                        <Store>
                            <ext:Store
                                ID="storNoteVisit"
                                AutoLoad="true"
                                runat="server">
                                <Model>
                                    <ext:Model ID="mdlNoteVisit" runat="Server" IDProperty="VISIT_DATETIME">
                                        <Fields>
                                            <ext:ModelField Name="VISIT_ID" />
                                            <ext:ModelField Name="VISIT_LOCATION_ID" />
                                            <ext:ModelField Name="VISIT_LOCATION_NAME" />
                                            <ext:ModelField Name="VISIT_TIMESTAMP" />
                                            <ext:ModelField Name="VISIT_STATUS" />
                                            <ext:ModelField Name="VISIT_TYPE" />
                                            <ext:ModelField Name="VISIT_DATETIME" Type="Date" />
                                        </Fields>
                                    </ext:Model>
                                </Model>
                                <Reader>
                                    <ext:JsonReader RootProperty="Tables[0].Rows">
                                    </ext:JsonReader>
                                </Reader>
                            </ext:Store>
                        </Store>
                    </ext:GridPanel>

                </Items>
            </ext:Panel>


            <ext:Panel ID="tpHospitalAdmissions"
                runat="server"
                Title="Hospital Admissions"
                AutoDataBind="true" Border="false" >
                <Items>

                    <ext:Panel ID="pnlAdmitDateRange" Layout="ColumnLayout" runat="server" Border="false" >
                        <Items>

                            <ext:Label ID="lblAdmitFrom" Text="From" runat="server" Padding="3"></ext:Label>
                            <ext:DateField ID="dfAdmitFromDate"
                                runat="server"
                                AllowBlank="false"
                                AutoDataBind="true"
                                Width="100"
                                Padding="5"
                                Format="MM/dd/yyyy"
                                Vtype="date"
                                InvalidText="{0} is not a valid date - it must be in the format MM/DD/YYYY">
                                <Listeners>
                                    <Change Fn="fnNoteAdminValForm" />
                                </Listeners>
                            </ext:DateField>

                            <ext:Label ID="lblAdmitTo" Text="Through" runat="server" Padding="3"></ext:Label>
                            <ext:DateField ID="dfAdmitToDate"
                                runat="server"
                                AllowBlank="false"
                                AutoDataBind="true"
                                Width="100"
                                Padding="5"
                                Format="MM/dd/yyyy"
                                Vtype="date"
                                InvalidText="{0} is not a valid date - it must be in the format MM/DD/YYYY">
                                <Listeners>
                                    <Change Fn="fnNoteAdminValForm" />
                                </Listeners>
                            </ext:DateField>

                            <ext:Button Text="Search Admissions" Handler="App.direct.UCNOTESEL.SearchAdmissions();" Padding="5" Icon="Magnifier"
                                ID="btnSearchAdmissions" runat="server">
                                <Listeners>

                                </Listeners>
                            </ext:Button>

                        </Items>
                    </ext:Panel>


                    <ext:GridPanel
                        ID="gpNoteAdmit"
                        runat="server"
                        AnchorHorizontal="98%"
                        Height="190"
                        Padding="1" Border="false" 
                        >
                        <Listeners>
                            <CellClick Handler="App.direct.UCNOTESEL.OnAdmissionSelect( Ext.encode(this.store.getAt(rowIndex).data) );" />
                        </Listeners>
                        <SelectionModel>
                            <ext:RowSelectionModel ID="smNoteAdmit" runat="server" />
                        </SelectionModel>
                        <ColumnModel ID="cmdlAdmit" runat="server">
                            <Columns>

                                <ext:DateColumn runat="server"
                                    DataIndex="ADMIT_DATETIME" Text="Date/Time"
                                    Flex="23" Format="Y-m-dd HH:i:s"  />

                                <ext:Column runat="server"
                                    DataIndex="ADMIT_LOCATION_NAME" Text="Location"
                                    Flex="48">
                                <Renderer Handler="return Ext.util.Format.htmlDecode(value);" />
                                </ext:Column>

                                <ext:Column runat="server"
                                    DataIndex="ADMIT_TYPE" Text="Type"
                                    Flex="23">
                                <Renderer Handler="return Ext.util.Format.htmlDecode(value);" />
                                </ext:Column>

                            </Columns>
                        </ColumnModel>
                        <Store>
                            <ext:Store
                                ID="storNoteAdmit"
                                AutoLoad="true"
                                runat="server">
                                <Model>
                                    <ext:Model ID="mdlNoteAdmit" runat="Server" IDProperty="ADMIT_DATETIME">
                                        <Fields>
                                            <ext:ModelField Name="REGION_ID" />
                                            <ext:ModelField Name="SITE_ID" />
                                            <ext:ModelField Name="DFN" />
                                            <ext:ModelField Name="ADMIT_LOCATION_ID" />
                                            <ext:ModelField Name="ADMIT_DATETIME" Type="Date" />
                                            <ext:ModelField Name="ADMIT_LOCATION_NAME" />
                                            <ext:ModelField Name="ADMIT_TYPE" />
                                            <ext:ModelField Name="ADMIT_TIMESTAMP" />
                                            <ext:ModelField Name="ADMIT_DISCHARGE_TIMESTAMP" />
                                        </Fields>
                                    </ext:Model>
                                </Model>
                                <Reader>
                                    <ext:JsonReader RootProperty="Tables[0].Rows">
                                    </ext:JsonReader>
                                </Reader>
                            </ext:Store>
                        </Store>
                    </ext:GridPanel>
                </Items>
            </ext:Panel>

            <ext:Panel ID="tpNewVisit"
                runat="server"
                Title="New Visit"
                AutoDataBind="true" Border="false" >
                <Items>

                    <ext:Panel Layout="ColumnLayout" runat="server" Border="false" >
                        <Items>
                            <ext:Label Text="Date/Time of Visit" runat="server" Padding="3"></ext:Label>
                            <ext:DateField ID="dfNewVisitDate"
                                runat="server"
                                AllowBlank="false"
                                AutoDataBind="true"
                                Width="100"
                                Padding="4"
                                Format="MM/dd/yyyy"
                                Vtype="date"
                                InvalidText="{0} is not a valid date - it must be in the format MM/DD/YYYY">
                            <Listeners>
                                <Change Handler="if(App.dfNewVisitDate.isValid()) {App.direct.UCNOTESEL.OnDateChange(Ext.encode(#{gpNoteClinic}.getRowsValues({selectedOnly : true})) );}" />
                            </Listeners>
                            </ext:DateField>
                            <ext:TimeField ID="tfNewVisitTime" runat="server"
                                Padding="5" Width="100"
                                MinTime="0:00" 
                                MaxTime="23:59" Format="HH:mm" 
                                Increment="15"
                                Vtype="time2">
                            <Listeners>
                                <Change Handler="if(App.tfNewVisitTime.isValid()) {App.direct.UCNOTESEL.OnTimeChange(Ext.encode(#{gpNoteClinic}.getRowsValues({selectedOnly : true})) );}" />
                            </Listeners>
                            </ext:TimeField>

                            <ext:Checkbox LabelAlign="Right" ID="chkHistoricalNewVisit" Padding="2" runat="server">
                            <Listeners>
                                <Change Handler="App.direct.UCNOTESEL.OnHistorical(this.checked, Ext.encode(#{gpNoteClinic}.getRowsValues({selectedOnly : true})) );" />
                            </Listeners>
                            </ext:Checkbox>
                            <ext:Label Text="Historical" runat="server" Padding="5"></ext:Label>

                            <ext:Label Padding="5" Text="" runat="server"></ext:Label>

                            <ext:Label Padding="5" Text="Search" runat="server"></ext:Label>

                            <ext:TextField AutoDataBind="true" MinLength="3" MaxLength="50"
                                Padding="3" ID="tfClinicSearch" ReadOnly="false" Width="230" runat="server" Vtype="alphanumXSS">
                                <Listeners>
                                    <Change Fn="fnNewVisitValSearch" />
                                </Listeners>
                            </ext:TextField>

                            <ext:Button Text="Search Clinics" Handler="App.direct.UCNOTESEL.SearchClinics();" Padding="5" 
                                Icon="Magnifier" ID="btnSearchClinic" runat="server">
                                <Listeners>

                                </Listeners>
                            </ext:Button>


                        </Items>
                    </ext:Panel>

                    <ext:GridPanel
                        ID="gpNoteClinic"
                        runat="server"
                        AnchorHorizontal="98%"
                        Height="190"
                        Padding="1" Border="false" 
                        >
                        <Listeners>
                            <CellClick Handler="App.direct.UCNOTESEL.OnClinicSelect( Ext.encode(this.store.getAt(rowIndex).data) );" />
                        </Listeners>
                        <SelectionModel>
                            <ext:RowSelectionModel ID="smNoteClinic" runat="server" />
                        </SelectionModel>
                        <ColumnModel ID="cmdlClinic" runat="server">
                            <Columns>

                                <ext:Column runat="server"
                                    DataIndex="CLINIC_LABEL" Text="Clinic"
                                    Flex="97">
                                <Renderer Handler="return Ext.util.Format.htmlDecode(value);" />
                                </ext:Column>

                            </Columns>
                        </ColumnModel>
                        <Store>
                            <ext:Store
                                ID="storNoteClinic"
                                AutoLoad="true"
                                runat="server">
                                <Model>
                                    <ext:Model ID="mdlNoteClinic" runat="Server" IDProperty="CLINIC_ID">
                                        <Fields>
                                            <ext:ModelField Name="REGION_ID" />
                                            <ext:ModelField Name="SITE_ID" />
                                            <ext:ModelField Name="CLINIC_ID" />
                                            <ext:ModelField Name="CLINIC_LABEL" />
                                        </Fields>
                                    </ext:Model>
                                </Model>
                                <Reader>
                                    <ext:JsonReader RootProperty="Tables[0].Rows">
                                    </ext:JsonReader>
                                </Reader>
                            </ext:Store>
                        </Store>
                    </ext:GridPanel>
                    
                </Items>
            </ext:Panel>

            <ext:Panel ID="tpCoSigner"
                runat="server"
                Title="Cosigner"
                AutoDataBind="true" Border="false" >
                <Items>

                    <ext:Panel Layout="ColumnLayout" runat="server" Border="false" >
                        <Items>
                            <ext:Label Padding="5" Text="Search" runat="server"></ext:Label>

                            <ext:TextField MinLength="3" MaxLength="50" Padding="3" ID="tfCosignerSearch" ReadOnly="false"
                                Width="300" runat="server">
                            </ext:TextField>

                            <ext:Button Text="Search Cosigners" Handler="App.direct.UCNOTESEL.SearchCosigner();"
                                Padding="5" Icon="Magnifier" ID="btnSearchCosigner" runat="server">
                                <Listeners>

                                </Listeners>
                            </ext:Button>
                        </Items>
                    </ext:Panel>

                    <ext:GridPanel
                        ID="gpNoteCosigner"
                        runat="server"
                        AnchorHorizontal="98%"
                        Height="190"
                        Padding="1" Border="false" >
                        <Listeners>
                            <CellClick Handler="App.direct.UCNOTESEL.OnCosignerSelect( Ext.encode(this.store.getAt(rowIndex).data) );" />
                        </Listeners>
                        <SelectionModel>
                            <ext:RowSelectionModel ID="smNoteCosigner" runat="server" />
                        </SelectionModel>
                        <ColumnModel ID="cmNoteCosigner" runat="server">
                            <Columns>

                                <ext:Column runat="server"
                                    DataIndex="NAME" Text="Name"
                                    Flex="63">
                                <Renderer Handler="return Ext.util.Format.htmlDecode(value);" />
                                </ext:Column>

                                <ext:Column runat="server"
                                    DataIndex="TITLE" Text="Title"
                                    Flex="33">
                                <Renderer Handler="return Ext.util.Format.htmlDecode(value);" />
                                </ext:Column>

                            </Columns>
                        </ColumnModel>
                        <Store>
                            <ext:Store
                                ID="storNoteCosigner"
                                AutoLoad="true"
                                runat="server">
                                <Model>
                                    <ext:Model ID="mdlNoteCosigner" runat="Server" IDProperty="FX_USER_ID">
                                        <Fields>
                                            <ext:ModelField Name="NAME" />
                                            <ext:ModelField Name="TITLE" />
                                            <ext:ModelField Name="PROVIDER_ID" />
                                            <ext:ModelField Name="FX_USER_ID" />
                                        </Fields>
                                    </ext:Model>
                                </Model>
                                <Reader>
                                    <ext:JsonReader RootProperty="Tables[0].Rows">
                                    </ext:JsonReader>
                                </Reader>
                            </ext:Store>
                        </Store>
                    </ext:GridPanel>
                    
                </Items>
            </ext:Panel>
            
        </Items>
    </ext:TabPanel>
</Items>
<BottomBar>
    <ext:Toolbar ID="tbNoteSelection" runat="server">
    <Items>
        <ext:Button ID="btnEventNoteOK" runat="server" Text="OK" Icon="Disk">
        <Listeners>

        </Listeners>
        <DirectEvents>
            <Click OnEvent="OnEventNoteOK" Success="fnUCNoteSelUpdate" Failure="GeneralErrorHandler">
            <ExtraParams>
                <ext:Parameter Name="ExtraParamNoteTitle" Value="Ext.encode(#{tfNoteTitle}.getValue())" Mode="Raw" />
                <ext:Parameter Name="ExtraParamEncLocation" Value="Ext.encode(#{tfEncounterlocation}.getValue())" Mode="Raw" />
                <ext:Parameter Name="ExtraParamCosigner" Value="Ext.encode(#{tfCoSigner}.getValue())" Mode="Raw" />
                <ext:Parameter Name="ExtraParamConsult" Value="Ext.encode(#{tfEncConsult}.getValue())" Mode="Raw" />
            </ExtraParams>
            </Click>
        </DirectEvents>
        </ext:Button>

        <ext:Button ID="btnNoteSelCancel" runat="server" Text="Cancel" Icon="Cancel" Handler="App.direct.UCNOTESEL.OnNoteSelSelCancel()" >
        <Listeners>

        </Listeners>
        </ext:Button>

    </Items>
    </ext:Toolbar>
</BottomBar>
     <Listeners>
        <Hide Fn="fnHideNoteSelection" />
    </Listeners>
</ext:Window>
